<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel ">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-3 d-inline">
                    <h1 class="title1 text-{{ $text }} d-inline mr-4">App Settings</h1>
                </div>

                 <x-bootstrap-alerts />
                @if (count($errors) > 0)
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="alert alert-danger alert-dismissable" role="alert">
                                <button type="button" clsass="close" data-dismiss="alert"
                                    aria-hidden="true">&times;</button>
                                @foreach ($errors->all() as $error)
                                    <i class="fa fa-warning"></i> {{ $error }}
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
                <div class="mt-2 mb-5 row">
                    <div class="col-12">
                        <di>
                            <a class='btn btn-primary' href='http://codesremedy.net/'>
                                Vist our website 
                            </a>
                        </di>
                        <div class="card p-md-5 p-2 shadow-lg ">
                            <ul class="nav nav-pills">
                                <li class="nav-item">
                                    <a href="#module" class="nav-link " data-toggle="tab">Module</a>
                                </li>
                                <li class="nav-item">
                                    <a href="#info" class="nav-link  active" data-toggle="tab">Website Information</a>
                                </li>
                                <li class="nav-item">
                                    <a href="#pref" class="nav-link" data-toggle="tab">Preference</a>
                                </li>
                                <li class="nav-item">
                                    <a href="#email" class="nav-link" data-toggle="tab">Email/Google Login-Captcha</a>
                                </li>
                                <li class="nav-item">
                                    <a href="#display" class="nav-link" data-toggle="tab">Theme/Display</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade  " id="module">
                                    <livewire:admin.software-module />
                                </div>
                                <div class="tab-pane fade show active" id="info">
                                    @include('admin.Settings.AppSettings.webinfo')
                                </div>
                                <div class="tab-pane fade" id="pref">
                                    @include('admin.Settings.AppSettings.webpreference')
                                </div>
                                <div class="tab-pane fade" id="email">
                                    @include('admin.Settings.AppSettings.email')
                                </div>
                                <div class="tab-pane fade" id='display'>
                                     @include('admin.Settings.AppSettings.theme')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script>
            $('.select2').select2();

            // Debug: Check if jQuery is loaded
            if (typeof $ === 'undefined') {
                console.error('jQuery is not loaded!');
            } else {
                console.log('jQuery is loaded successfully');
            }

            // Debug: Check if form exists
            if ($('#updatepreference').length === 0) {
                console.error('Form with ID updatepreference not found!');
            } else {
                console.log('Form found successfully');
            }

            document.getElementById("themeForm").addEventListener('submit', function(){
                document.getElementById("themeBtn").disabled = true;
                var element = document.getElementById("loadingTheme");
                element.classList.remove("d-none");
            });

            function changecurr() {
                var e = document.getElementById("select_c");
                var selected = e.options[e.selectedIndex].id;
                document.getElementById("s_c").value = selected;
                console.log(selected);
            }



            // Form submission handler - wrapped in document ready
            $(document).ready(function() {
                console.log('Document ready - setting up form handler');

                $('#updatepreference').on('submit', function(e) {
                    e.preventDefault(); // Prevent default form submission

                    console.log('Form submission started'); // Debug log

                    // Validate that route exists
                    try {
                        var routeUrl = "{{ route('updatepreference') }}";
                        console.log('Route URL:', routeUrl);
                    } catch(error) {
                        console.error('Route error:', error);
                        alert('Route configuration error. Please check with administrator.');
                        return false;
                    }

                    $.ajax({
                        url: "{{ route('updatepreference') }}",
                        type: 'POST',
                        data: $('#updatepreference').serialize(),
                        beforeSend: function() {
                            // Disable submit button to prevent double submission
                            $('#updatepreference input[type="submit"]').prop('disabled', true).val('Saving...');
                            console.log('Sending data:', $('#updatepreference').serialize());
                        },
                        success: function(response) {
                            console.log('Ajax success:', response); // Debug log

                            if (response.status === 200) {
                                $.notify({
                                    // options
                                    icon: 'flaticon-alarm-1',
                                    title: 'Success',
                                    message: response.success,
                                }, {
                                    // settings
                                    type: 'success',
                                    allow_dismiss: true,
                                    newest_on_top: false,
                                    placement: {
                                        from: "top",
                                        align: "right"
                                    },
                                    offset: 20,
                                    spacing: 10,
                                    z_index: 1031,
                                    delay: 5000,
                                    timer: 1000,
                                    animate: {
                                        enter: 'animated fadeInDown',
                                        exit: 'animated fadeOutUp'
                                    },
                                });
                            } else {
                                console.log('Unexpected response status:', response.status);
                                $.notify({
                                    icon: 'flaticon-cross',
                                    title: 'Error',
                                    message: 'Something went wrong. Please try again.',
                                }, {
                                    type: 'danger',
                                    allow_dismiss: true,
                                    placement: {
                                        from: "top",
                                        align: "right"
                                    },
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            console.log('Ajax error:', xhr.responseText); // Better error logging
                            console.log('Status:', status);
                            console.log('Error:', error);
                            console.log('XHR object:', xhr);

                            let errorMessage = 'An error occurred while saving preferences.';

                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            } else if (xhr.responseText) {
                                errorMessage = 'Server error: ' + xhr.status;
                            }

                            $.notify({
                                icon: 'flaticon-cross',
                                title: 'Error',
                                message: errorMessage,
                            }, {
                                type: 'danger',
                                allow_dismiss: true,
                                placement: {
                                    from: "top",
                                    align: "right"
                                },
                            });
                        },
                        complete: function() {
                            // Re-enable submit button
                            $('#updatepreference input[type="submit"]').prop('disabled', false).val('Save');
                        }
                    });

                    return false; // Additional prevention of default submission
                });
            });

            let sendmail = document.querySelector('#sendmailserver');
            let smtp = document.querySelector('#smtpserver');
            let smtptext = document.querySelectorAll('.smtp');
            //console.log(sendmail);
            sendmail.addEventListener('click', sortform);
            smtp.addEventListener('click', sortform);

            if (smtp.checked) {
                smtptext.forEach(smtps => {
                    smtps.classList.remove('d-none');
                    smtps.setAttribute('required', '');
                });
            }

            function sortform() {
                if (sendmail.checked) {
                    smtptext.forEach(element => {
                        element.classList.add('d-none');
                        element.removeAttribute('required', '');
                    });
                }
                if (smtp.checked) {
                    smtptext.forEach(smtps => {
                        smtps.classList.remove('d-none');
                        smtps.setAttribute('required', '');
                    });
                }
            }

            // Submit email preference form - wrapped in document ready
            $(document).ready(function() {
                $('#emailform').on('submit', function(e) {
                    e.preventDefault(); // Prevent default form submission

                    console.log('Email form submission started'); // Debug log

                    // Validate that route exists
                    try {
                        var routeUrl = "{{ route('updateemailpreference') }}";
                        console.log('Email Route URL:', routeUrl);
                    } catch(error) {
                        console.error('Email route error:', error);
                        alert('Route configuration error. Please check with administrator.');
                        return false;
                    }

                    $.ajax({
                        url: "{{ route('updateemailpreference') }}",
                        type: 'POST',
                        data: $('#emailform').serialize(),
                        beforeSend: function() {
                            // Disable submit button to prevent double submission
                            $('#emailform input[type="submit"]').prop('disabled', true).val('Saving...');
                            console.log('Sending email data:', $('#emailform').serialize());
                        },
                        success: function(response) {
                            console.log('Email Ajax success:', response); // Debug log

                            if (response.status === 200) {
                                $.notify({
                                    // options
                                    icon: 'flaticon-alarm-1',
                                    title: 'Success',
                                    message: response.success,
                                }, {
                                    // settings
                                    type: 'success',
                                    allow_dismiss: true,
                                    newest_on_top: false,
                                    placement: {
                                        from: "top",
                                        align: "right"
                                    },
                                    offset: 20,
                                    spacing: 10,
                                    z_index: 1031,
                                    delay: 5000,
                                    timer: 1000,
                                    animate: {
                                        enter: 'animated fadeInDown',
                                        exit: 'animated fadeOutUp'
                                    },
                                });
                            } else {
                                console.log('Unexpected email response status:', response.status);
                                $.notify({
                                    icon: 'flaticon-cross',
                                    title: 'Error',
                                    message: response.error || 'Something went wrong. Please try again.',
                                }, {
                                    type: 'danger',
                                    allow_dismiss: true,
                                    placement: {
                                        from: "top",
                                        align: "right"
                                    },
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            console.log('Email Ajax error:', xhr.responseText); // Better error logging
                            console.log('Status:', status);
                            console.log('Error:', error);
                            console.log('XHR object:', xhr);

                            let errorMessage = 'An error occurred while saving email settings.';

                            if (xhr.responseJSON) {
                                if (xhr.responseJSON.error) {
                                    errorMessage = xhr.responseJSON.error;
                                } else if (xhr.responseJSON.errors) {
                                    // Handle validation errors
                                    let validationErrors = Object.values(xhr.responseJSON.errors).flat();
                                    errorMessage = 'Validation errors: ' + validationErrors.join(', ');
                                }
                            } else if (xhr.responseText) {
                                errorMessage = 'Server error: ' + xhr.status + ' - ' + xhr.statusText;
                            }

                            $.notify({
                                icon: 'flaticon-cross',
                                title: 'Error',
                                message: errorMessage,
                            }, {
                                type: 'danger',
                                allow_dismiss: true,
                                placement: {
                                    from: "top",
                                    align: "right"
                                },
                            });
                        },
                        complete: function() {
                            // Re-enable submit button
                            $('#emailform input[type="submit"]').prop('disabled', false).val('Save');
                        }
                    });

                    return false; // Additional prevention of default submission
                });
            });
        </script>
    @endsection
