<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Manage Email Transactions</h1>
                </div>

                {{-- Bootstrap Alert Components --}}
                <x-bootstrap-alerts />

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-primary bubble-shadow-small">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Total Emails</p>
                                            <h4 class="card-title">{{ $stats['total'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-success bubble-shadow-small">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Sent Successfully</p>
                                            <h4 class="card-title">{{ $stats['sent'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-warning bubble-shadow-small">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Pending</p>
                                            <h4 class="card-title">{{ $stats['pending'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-danger bubble-shadow-small">
                                            <i class="fas fa-times-circle"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Failed</p>
                                            <h4 class="card-title">{{ $stats['failed'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="mb-5 row">
                    <div class="col card p-3 shadow">
                        <div class="bs-example widget-shadow table-responsive" data-example-id="hoverable-table">
                            <span style="margin:3px;">
                                <table id="EmailTransactionTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>User</th>
                                            <th>Exchange</th>
                                            <th>Recipient Email</th>
                                            <th>Amount</th>
                                            <th>Currency</th>
                                            <th>Status</th>
                                            <th>Date Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($emailTransactions as $transaction)
                                            <tr>
                                                <td>
                                                    <strong>#{{ str_pad($transaction->id, 6, '0', STR_PAD_LEFT) }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $transaction->transaction_id }}</small>
                                                </td>
                                                <td>
                                                    <strong>{{ $transaction->user->name }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $transaction->user->email }}</small>
                                                </td>
                                                <td>
                                                    <strong>{{ $transaction->exchange_name }}</strong>
                                                    @if($transaction->template_used)
                                                    <br>
                                                    <small class="text-muted">{{ ucwords(str_replace('-', ' ', $transaction->template_used)) }}</small>
                                                    @endif
                                                </td>
                                                <td>{{ $transaction->receiver_email }}</td>
                                                <td>
                                                    <strong>{{ $settings->currency }}{{ number_format($transaction->amount, 2) }}</strong>
                                                    @if($transaction->transaction_fee > 0)
                                                    <br>
                                                    <small class="text-muted">Fee: {{ $settings->currency }}{{ number_format($transaction->transaction_fee, 2) }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    <span class="badge badge-info">{{ $transaction->coin_symbol }}/{{ $transaction->currency }}</span>
                                                </td>
                                                <td>
                                                    @if ($transaction->status == 'sent')
                                                        <span class="badge badge-success">
                                                            <i class="fas fa-check"></i> Sent
                                                        </span>
                                                    @elseif ($transaction->status == 'pending')
                                                        <span class="badge badge-warning">
                                                            <i class="fas fa-clock"></i> Pending
                                                        </span>
                                                    @else
                                                        <span class="badge badge-danger">
                                                            <i class="fas fa-times"></i> Failed
                                                        </span>
                                                    @endif
                                                </td>
                                                <td>
                                                    {{ \Carbon\Carbon::parse($transaction->created_at)->toDayDateTimeString() }}
                                                    @if($transaction->sent_at)
                                                    <br>
                                                    <small class="text-success">Sent: {{ \Carbon\Carbon::parse($transaction->sent_at)->format('M j, g:i A') }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="{{ route('admin.email-transaction.show', $transaction->id) }}"
                                                           class="btn btn-info btn-sm" title="View Details">
                                                            <i class="fa fa-eye"></i>
                                                        </a>

                                                        @if($transaction->status === 'failed' || $transaction->status === 'pending')
                                                        <form action="{{ route('admin.email-transaction.resend', $transaction->id) }}"
                                                              method="POST" style="display: inline;">
                                                            @csrf
                                                            <button type="submit" class="btn btn-warning btn-sm"
                                                                    title="Resend Email"
                                                                    onclick="return confirm('Are you sure you want to resend this email?')">
                                                                <i class="fa fa-redo"></i>
                                                            </button>
                                                        </form>
                                                        @endif

                                                        <form action="{{ route('admin.email-transaction.destroy', $transaction->id) }}"
                                                              method="POST" style="display: inline;">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-sm"
                                                                    title="Delete Transaction"
                                                                    onclick="return confirm('Are you sure you want to delete this email transaction?')">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </span>
                        </div>

                        <!-- Pagination -->
                        @if($emailTransactions->hasPages())
                        <div class="mt-3 d-flex justify-content-center">
                            {{ $emailTransactions->links() }}
                        </div>
                        @endif

                        @if($emailTransactions->count() == 0)
                        <div class="text-center py-5">
                            <i class="fas fa-envelope fa-3x text-muted mb-3"></i>
                            <h4 class="text-muted">No Email Transactions Found</h4>
                            <p class="text-muted">No users have sent any flash emails yet.</p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTables Script -->
    <script>
        $(document).ready(function() {
            $('#EmailTransactionTable').DataTable({
                "pageLength": 25,
                "order": [[ 7, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": 8 }
                ]
            });
        });
    </script>
@endsection
