<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Email Transaction Details</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.email-transactions') }}">Email Transactions</a></li>
                            <li class="breadcrumb-item active">#{{ str_pad($emailTransaction->id, 6, '0', STR_PAD_LEFT) }}</li>
                        </ol>
                    </nav>
                </div>

{{-- Bootstrap Alert Components --}}
                <x-bootstrap-alerts />

                <div class="row">
                    <!-- Transaction Details -->
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">
                                    Transaction #{{ str_pad($emailTransaction->id, 6, '0', STR_PAD_LEFT) }}
                                    @if ($emailTransaction->status == 'sent')
                                        <span class="badge badge-success ml-2">
                                            <i class="fas fa-check"></i> Sent
                                        </span>
                                    @elseif ($emailTransaction->status == 'pending')
                                        <span class="badge badge-warning ml-2">
                                            <i class="fas fa-clock"></i> Pending
                                        </span>
                                    @else
                                        <span class="badge badge-danger ml-2">
                                            <i class="fas fa-times"></i> Failed
                                        </span>
                                    @endif
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td><strong>Transaction ID:</strong></td>
                                                <td><code>{{ $emailTransaction->transaction_id }}</code></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Exchange:</strong></td>
                                                <td>{{ $emailTransaction->exchange_name }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Template Used:</strong></td>
                                                <td>
                                                    @if($emailTransaction->template_used)
                                                        <span class="badge badge-info">{{ ucwords(str_replace('-', ' ', $emailTransaction->template_used)) }}</span>
                                                    @else
                                                        <span class="text-muted">Not specified</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Amount:</strong></td>
                                                <td class="text-success font-weight-bold">{{ $settings->currency }}{{ number_format($emailTransaction->amount, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Transaction Fee:</strong></td>
                                                <td>{{ $settings->currency }}{{ number_format($emailTransaction->transaction_fee, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Currency Pair:</strong></td>
                                                <td><span class="badge badge-primary">{{ $emailTransaction->coin_symbol }}/{{ $emailTransaction->currency }}</span></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td><strong>Recipient Email:</strong></td>
                                                <td>{{ $emailTransaction->receiver_email }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Sender Name:</strong></td>
                                                <td>{{ $emailTransaction->sender_name ?? 'Not specified' }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Created At:</strong></td>
                                                <td>{{ \Carbon\Carbon::parse($emailTransaction->created_at)->toDayDateTimeString() }}</td>
                                            </tr>
                                            @if($emailTransaction->sent_at)
                                            <tr>
                                                <td><strong>Sent At:</strong></td>
                                                <td class="text-success">{{ \Carbon\Carbon::parse($emailTransaction->sent_at)->toDayDateTimeString() }}</td>
                                            </tr>
                                            @endif
                                            @if($emailTransaction->error_message)
                                            <tr>
                                                <td><strong>Error Message:</strong></td>
                                                <td class="text-danger">{{ $emailTransaction->error_message }}</td>
                                            </tr>
                                            @endif
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- User Information -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h4 class="card-title">User Information</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td><strong>Name:</strong></td>
                                                <td>{{ $emailTransaction->user->name }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Email:</strong></td>
                                                <td>{{ $emailTransaction->user->email }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Account Balance:</strong></td>
                                                <td class="text-info font-weight-bold">{{ $settings->currency }}{{ number_format($emailTransaction->user->account_bal, 2) }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td><strong>User Status:</strong></td>
                                                <td>
                                                    @if($emailTransaction->user->status == 'active')
                                                        <span class="badge badge-success">Active</span>
                                                    @else
                                                        <span class="badge badge-danger">{{ ucfirst($emailTransaction->user->status) }}</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Registration Date:</strong></td>
                                                <td>{{ \Carbon\Carbon::parse($emailTransaction->user->created_at)->toDayDateTimeString() }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Panel -->
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Actions</h4>
                            </div>
                            <div class="card-body">
                                <!-- Status Update Form -->
                                <form action="{{ route('admin.email-transaction.update-status', $emailTransaction->id) }}" method="POST" class="mb-3">
                                    @csrf
                                    @method('PATCH')
                                    <div class="form-group">
                                        <label for="status">Update Status:</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="pending" {{ $emailTransaction->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                            <option value="sent" {{ $emailTransaction->status == 'sent' ? 'selected' : '' }}>Sent</option>
                                            <option value="failed" {{ $emailTransaction->status == 'failed' ? 'selected' : '' }}>Failed</option>
                                        </select>
                                    </div>
                                    <div class="form-group" id="error-message-group" style="display: none;">
                                        <label for="error_message">Error Message:</label>
                                        <textarea name="error_message" id="error_message" class="form-control" rows="3">{{ $emailTransaction->error_message }}</textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary btn-sm btn-block">
                                        <i class="fas fa-save"></i> Update Status
                                    </button>
                                </form>

                                <hr>

                                <!-- Action Buttons -->
                                @if($emailTransaction->status !== 'sent')
                                <form action="{{ route('admin.email-transaction.resend', $emailTransaction->id) }}" method="POST" class="mb-2">
                                    @csrf
                                    <button type="submit" class="btn btn-warning btn-sm btn-block"
                                            onclick="return confirm('Are you sure you want to resend this email?')">
                                        <i class="fas fa-redo"></i> Resend Email
                                    </button>
                                </form>
                                @endif

                                <a href="{{ route('admin.email-transactions') }}" class="btn btn-secondary btn-sm btn-block">
                                    <i class="fas fa-arrow-left"></i> Back to List
                                </a>

                                <form action="{{ route('admin.email-transaction.destroy', $emailTransaction->id) }}" method="POST" class="mt-3">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm btn-block"
                                            onclick="return confirm('Are you sure you want to delete this email transaction? This action cannot be undone.')">
                                        <i class="fas fa-trash"></i> Delete Transaction
                                    </button>
                                </form>
                            </div>
                        </div>

                        <!-- Timeline -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h4 class="card-title">Timeline</h4>
                            </div>
                            <div class="card-body">
                                <div class="timeline">
                                    <div class="timeline-item">
                                        <div class="timeline-point timeline-point-primary">
                                            <i class="fas fa-plus"></i>
                                        </div>
                                        <div class="timeline-content">
                                            <h6 class="timeline-title">Transaction Created</h6>
                                            <p class="timeline-text">{{ \Carbon\Carbon::parse($emailTransaction->created_at)->toDayDateTimeString() }}</p>
                                        </div>
                                    </div>

                                    @if($emailTransaction->sent_at)
                                    <div class="timeline-item">
                                        <div class="timeline-point timeline-point-success">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div class="timeline-content">
                                            <h6 class="timeline-title">Email Sent</h6>
                                            <p class="timeline-text">{{ \Carbon\Carbon::parse($emailTransaction->sent_at)->toDayDateTimeString() }}</p>
                                        </div>
                                    </div>
                                    @elseif($emailTransaction->status == 'failed')
                                    <div class="timeline-item">
                                        <div class="timeline-point timeline-point-danger">
                                            <i class="fas fa-times"></i>
                                        </div>
                                        <div class="timeline-content">
                                            <h6 class="timeline-title">Email Failed</h6>
                                            <p class="timeline-text">{{ \Carbon\Carbon::parse($emailTransaction->updated_at)->toDayDateTimeString() }}</p>
                                            @if($emailTransaction->error_message)
                                            <p class="timeline-text text-danger"><small>{{ $emailTransaction->error_message }}</small></p>
                                            @endif
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Show/hide error message field based on status selection
        document.getElementById('status').addEventListener('change', function() {
            const errorGroup = document.getElementById('error-message-group');
            if (this.value === 'failed') {
                errorGroup.style.display = 'block';
            } else {
                errorGroup.style.display = 'none';
            }
        });

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            const status = document.getElementById('status').value;
            const errorGroup = document.getElementById('error-message-group');
            if (status === 'failed') {
                errorGroup.style.display = 'block';
            }
        });
    </script>

    <style>
        .timeline {
            position: relative;
            padding-left: 30px;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 15px;
            top: 0;
            bottom: 0;
            width: 2px;
            background-color: #dee2e6;
        }

        .timeline-item {
            position: relative;
            margin-bottom: 20px;
        }

        .timeline-point {
            position: absolute;
            left: -22px;
            top: 5px;
            width: 14px;
            height: 14px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 8px;
            color: white;
        }

        .timeline-point-primary { background-color: #007bff; }
        .timeline-point-success { background-color: #28a745; }
        .timeline-point-danger { background-color: #dc3545; }

        .timeline-title {
            margin-bottom: 5px;
            font-weight: 600;
        }

        .timeline-text {
            margin-bottom: 0;
            color: #6c757d;
            font-size: 0.875rem;
        }
    </style>
@endsection
