<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Airport;
use App\Models\Flight;
use Carbon\Carbon;

class PopularDestinationsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Popular destination airports
        $airports = [
            [
                'name' => 'John F. Kennedy International Airport',
                'iata_code' => 'JFK',
                'city' => 'New York',
                'country' => 'United States',
                'latitude' => 40.6413,
                'longitude' => -73.7781,
                'timezone' => 'America/New_York'
            ],
            [
                'name' => 'Los Angeles International Airport',
                'iata_code' => 'LAX',
                'city' => 'Los Angeles',
                'country' => 'United States',
                'latitude' => 33.9416,
                'longitude' => -118.4085,
                'timezone' => 'America/Los_Angeles'
            ],
            [
                'name' => 'Miami International Airport',
                'iata_code' => 'MIA',
                'city' => 'Miami',
                'country' => 'United States',
                'latitude' => 25.7959,
                'longitude' => -80.2870,
                'timezone' => 'America/New_York'
            ],
            [
                'name' => 'London Heathrow Airport',
                'iata_code' => 'LHR',
                'city' => 'London',
                'country' => 'United Kingdom',
                'latitude' => 51.4700,
                'longitude' => -0.4543,
                'timezone' => 'Europe/London'
            ],
            [
                'name' => 'Dubai International Airport',
                'iata_code' => 'DXB',
                'city' => 'Dubai',
                'country' => 'United Arab Emirates',
                'latitude' => 25.2532,
                'longitude' => 55.3657,
                'timezone' => 'Asia/Dubai'
            ],
            [
                'name' => 'Tokyo Haneda Airport',
                'iata_code' => 'HND',
                'city' => 'Tokyo',
                'country' => 'Japan',
                'latitude' => 35.5494,
                'longitude' => 139.7798,
                'timezone' => 'Asia/Tokyo'
            ]
        ];

        // Create airports
        $createdAirports = [];
        foreach ($airports as $airportData) {
            $airport = Airport::firstOrCreate(
                ['iata_code' => $airportData['iata_code']],
                $airportData
            );
            $createdAirports[] = $airport;
        }

        // Create sample flights to these destinations
        $airlines = ['United Airlines', 'Delta Airlines', 'American Airlines', 'Emirates', 'British Airways'];
        
        // Get an origin airport (create a generic one if needed)
        $originAirport = Airport::firstOrCreate(
            ['iata_code' => 'ATL'],
            [
                'name' => 'Hartsfield-Jackson Atlanta International Airport',
                'city' => 'Atlanta',
                'country' => 'United States',
                'latitude' => 33.6407,
                'longitude' => -84.4277,
                'timezone' => 'America/New_York'
            ]
        );

        // Create flights to each popular destination
        foreach ($createdAirports as $index => $airport) {
            for ($i = 0; $i < 3; $i++) {
                $departureTime = Carbon::now()->addDays(rand(1, 30))->setHour(rand(6, 22))->setMinute(rand(0, 59));
                $duration = rand(120, 600); // 2-10 hours in minutes
                $arrivalTime = $departureTime->copy()->addMinutes($duration);

                Flight::create([
                    'flight_number' => strtoupper(substr($airlines[$index % 5], 0, 2)) . rand(1000, 9999),
                    'airline' => $airlines[$index % 5],
                    'origin_airport_id' => $originAirport->id,
                    'destination_airport_id' => $airport->id,
                    'departure_time' => $departureTime,
                    'arrival_time' => $arrivalTime,
                    'price' => rand(199, 1299),
                    'seats_available' => rand(20, 150),
                    'seats_total' => 180,
                    'aircraft_type' => 'Boeing 737',
                    'status' => 'scheduled',
                    'gate' => 'A' . rand(1, 50),
                    'terminal' => (string)rand(1, 4)
                ]);
            }
        }

        $this->command->info('Popular destinations and flights seeded successfully!');
    }
}
