<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class AirportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $airports = [
            [
                'iata_code' => 'LAX',
                'icao_code' => 'KLAX',
                'name' => 'Los Angeles International Airport',
                'city' => 'Los Angeles',
                'country' => 'United States',
                'timezone' => 'America/Los_Angeles',
                'latitude' => 33.9425,
                'longitude' => -118.4081,
            ],
            [
                'iata_code' => 'JFK',
                'icao_code' => 'KJFK',
                'name' => 'John F. Kennedy International Airport',
                'city' => 'New York',
                'country' => 'United States',
                'timezone' => 'America/New_York',
                'latitude' => 40.6413,
                'longitude' => -73.7781,
            ],
            [
                'iata_code' => 'LHR',
                'icao_code' => 'EGLL',
                'name' => 'London Heathrow Airport',
                'city' => 'London',
                'country' => 'United Kingdom',
                'timezone' => 'Europe/London',
                'latitude' => 51.4700,
                'longitude' => -0.4543,
            ],
            [
                'iata_code' => 'CDG',
                'icao_code' => 'LFPG',
                'name' => 'Charles de Gaulle Airport',
                'city' => 'Paris',
                'country' => 'France',
                'timezone' => 'Europe/Paris',
                'latitude' => 49.0097,
                'longitude' => 2.5479,
            ],
            [
                'iata_code' => 'NRT',
                'icao_code' => 'RJAA',
                'name' => 'Narita International Airport',
                'city' => 'Tokyo',
                'country' => 'Japan',
                'timezone' => 'Asia/Tokyo',
                'latitude' => 35.7720,
                'longitude' => 140.3929,
            ],
            [
                'iata_code' => 'SIN',
                'icao_code' => 'WSSS',
                'name' => 'Singapore Changi Airport',
                'city' => 'Singapore',
                'country' => 'Singapore',
                'timezone' => 'Asia/Singapore',
                'latitude' => 1.3644,
                'longitude' => 103.9915,
            ],
            [
                'iata_code' => 'DXB',
                'icao_code' => 'OMDB',
                'name' => 'Dubai International Airport',
                'city' => 'Dubai',
                'country' => 'United Arab Emirates',
                'timezone' => 'Asia/Dubai',
                'latitude' => 25.2532,
                'longitude' => 55.3657,
            ],
            [
                'iata_code' => 'SYD',
                'icao_code' => 'YSSY',
                'name' => 'Sydney Kingsford Smith Airport',
                'city' => 'Sydney',
                'country' => 'Australia',
                'timezone' => 'Australia/Sydney',
                'latitude' => -33.9399,
                'longitude' => 151.1753,
            ],
            [
                'iata_code' => 'ORD',
                'icao_code' => 'KORD',
                'name' => "Chicago O'Hare International Airport",
                'city' => 'Chicago',
                'country' => 'United States',
                'timezone' => 'America/Chicago',
                'latitude' => 41.9742,
                'longitude' => -87.9073,
            ],
            [
                'iata_code' => 'MIA',
                'icao_code' => 'KMIA',
                'name' => 'Miami International Airport',
                'city' => 'Miami',
                'country' => 'United States',
                'timezone' => 'America/New_York',
                'latitude' => 25.7959,
                'longitude' => -80.2870,
            ],
        ];

        foreach ($airports as $airport) {
            \App\Models\Airport::firstOrCreate(
                ['iata_code' => $airport['iata_code']],
                $airport
            );
        }

        $this->command->info('Seeded ' . count($airports) . ' airports');
    }
}
