<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFlightBookingFieldsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // Flight booking passenger information
            $table->string('passenger_name')->nullable()->after('username');
            $table->string('passenger_email')->nullable()->after('passenger_name');
            $table->string('passenger_phone')->nullable()->after('passenger_email');
            $table->date('passenger_dob')->nullable()->after('passenger_phone');
            $table->string('passport_number')->nullable()->after('passenger_dob');
            $table->string('passport_country')->nullable()->after('passport_number');
            $table->date('passport_expiry')->nullable()->after('passport_country');
            $table->string('nationality')->nullable()->after('passport_expiry');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'passenger_name',
                'passenger_email', 
                'passenger_phone',
                'passenger_dob',
                'passport_number',
                'passport_country',
                'passport_expiry',
                'nationality'
            ]);
        });
    }
}
