<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPaymentFieldsToBookingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->string('payment_proof')->nullable()->after('payment_status');
            $table->foreignId('payment_method_id')->nullable()->after('payment_proof')->constrained('wdmethods')->onDelete('set null');
            $table->foreignId('deposit_id')->nullable()->after('payment_method_id')->constrained('deposits')->onDelete('set null');
            $table->enum('booking_type', ['guest', 'user'])->default('guest')->after('deposit_id');
            $table->string('transaction_id')->nullable()->after('booking_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropForeign(['payment_method_id']);
            $table->dropForeign(['deposit_id']);
            $table->dropColumn(['payment_proof', 'payment_method_id', 'deposit_id', 'booking_type', 'transaction_id']);
        });
    }
}
