<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class FixFlightsTableColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            // Check if old column names exist and rename them
            if (Schema::hasColumn('flights', 'origin_id')) {
                $table->renameColumn('origin_id', 'origin_airport_id');
            }
            if (Schema::hasColumn('flights', 'destination_id')) {
                $table->renameColumn('destination_id', 'destination_airport_id');
            }
            if (Schema::hasColumn('flights', 'available_seats')) {
                $table->renameColumn('available_seats', 'seats_available');
            }
            
            // Add missing columns if they don't exist
            if (!Schema::hasColumn('flights', 'origin_airport_id')) {
                $table->foreignId('origin_airport_id')->nullable()->constrained('airports');
            }
            if (!Schema::hasColumn('flights', 'destination_airport_id')) {
                $table->foreignId('destination_airport_id')->nullable()->constrained('airports');
            }
            if (!Schema::hasColumn('flights', 'seats_available')) {
                $table->integer('seats_available')->default(0);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            // This is intentionally left empty to prevent data loss
            // In production, you might want to add specific rollback logic
        });
    }
}
