<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateBookingsTableForPaymentIntegration extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->decimal('wdmethod_amount', 15, 2)->nullable()->after('price_paid');
            $table->string('wdmethod_type')->nullable()->after('wdmethod_amount'); // bitcoin, bank, stripe, paypal, etc.
            $table->string('wdmethod_currency', 3)->default('USD')->after('wdmethod_type');
            $table->decimal('commission_amount', 10, 2)->default(0)->after('wdmethod_currency');
            $table->unsignedBigInteger('referred_by')->nullable()->after('commission_amount');
            $table->timestamp('payment_initiated_at')->nullable()->after('referred_by');
            $table->timestamp('payment_completed_at')->nullable()->after('payment_initiated_at');
            $table->json('payment_details')->nullable()->after('payment_completed_at');
            
            // Foreign key for referral system
            $table->foreign('referred_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropForeign(['referred_by']);
            $table->dropColumn([
                'wdmethod_amount',
                'wdmethod_type',
                'wdmethod_currency',
                'commission_amount',
                'referred_by',
                'payment_initiated_at',
                'payment_completed_at',
                'payment_details'
            ]);
        });
    }
}
