<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBookingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('booking_reference')->unique(); // e.g., "ABC123"
            $table->foreignId('user_id')->nullable()->constrained('users'); // null for guest bookings
            $table->foreignId('flight_id')->constrained('flights');
            $table->string('passenger_name');
            $table->string('passenger_email');
            $table->string('passenger_phone')->nullable();
            $table->string('seat_number')->nullable(); // e.g., "12A"
            $table->decimal('price_paid', 10, 2);
            $table->enum('payment_status', ['pending', 'paid', 'refunded', 'failed'])
                  ->default('pending');
            $table->enum('status', ['confirmed', 'cancelled', 'checked_in', 'completed'])
                  ->default('confirmed');
            $table->json('passenger_details')->nullable(); // Additional passenger info
            $table->dateTime('checked_in_at')->nullable();
            $table->timestamps();
            
            $table->index(['user_id']);
            $table->index(['flight_id']);
            $table->index(['payment_status']);
            $table->index(['status']);
            $table->index(['passenger_email']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bookings');
    }
}
