<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFlightsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights', function (Blueprint $table) {
            $table->id();
            $table->string('airline'); // e.g., "American Airlines"
            $table->string('flight_number'); // e.g., "AA1234"
            $table->foreignId('origin_airport_id')->constrained('airports');
            $table->foreignId('destination_airport_id')->constrained('airports');
            $table->dateTime('departure_time');
            $table->dateTime('arrival_time');
            $table->enum('status', ['scheduled', 'boarding', 'departed', 'airborne', 'delayed', 'landed', 'cancelled'])
                  ->default('scheduled');
            $table->string('terminal')->nullable();
            $table->string('gate')->nullable();
            $table->string('aircraft_type')->nullable(); // e.g., "Boeing 737"
            $table->integer('seats_total');
            $table->integer('seats_available');
            $table->decimal('price', 10, 2); // Base price
            $table->decimal('tracking_lat', 10, 8)->nullable(); // Current latitude
            $table->decimal('tracking_lng', 11, 8)->nullable(); // Current longitude
            $table->integer('altitude')->nullable(); // In feet
            $table->integer('speed')->nullable(); // In knots
            $table->dateTime('last_position_updated_at')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users'); // Admin who created
            $table->timestamps();
            
            $table->index(['departure_time']);
            $table->index(['origin_airport_id', 'destination_airport_id']);
            $table->index(['status']);
            $table->unique(['airline', 'flight_number', 'departure_time']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights');
    }
}
