<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('transaction_reference')->unique();
            $table->string('exchange_name');
            $table->string('receiver_email');
            $table->string('sender_name');
            $table->string('sender_email');
            $table->string('coin_type');
            $table->string('currency', 10);
            $table->decimal('amount', 15, 8);
            $table->decimal('transaction_fee', 15, 8)->default(0);
            $table->string('wallet_address')->nullable();
            $table->string('transaction_hash')->nullable();
            $table->text('transaction_note')->nullable();
            $table->enum('status', ['pending', 'sent', 'delivered', 'failed'])->default('pending');
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('delivered_at')->nullable();
            $table->json('email_metadata')->nullable(); // Store additional email data
            $table->string('template_used')->nullable();
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            // Indexes for better performance
            $table->index(['user_id', 'status']);
            $table->index(['exchange_name', 'created_at']);
            $table->index('transaction_reference');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email_transactions');
    }
}
