<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Airport extends Model
{
    use HasFactory;

    protected $fillable = [
        'iata_code',
        'icao_code',
        'name',
        'city',
        'country',
        'timezone',
        'latitude',
        'longitude',
        'active',
    ];

    protected $casts = [
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'active' => 'boolean',
    ];

    // Relationships
    public function originFlights()
    {
        return $this->hasMany(Flight::class, 'origin_airport_id');
    }

    public function destinationFlights()
    {
        return $this->hasMany(Flight::class, 'destination_airport_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    // Accessors
    public function getFullNameAttribute()
    {
        return "{$this->name} ({$this->iata_code})";
    }

    public function getCityCountryAttribute()
    {
        return "{$this->city}, {$this->country}";
    }
}
