<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CryptoDepositMail extends Mailable
{
    use Queueable, SerializesModels;

    public $emailData;
    public $emailSubject;

    /**
     * Create a new message instance.
     */
    public function __construct(array $emailData, string $emailSubject)
    {
        $this->emailData = $emailData;
        $this->emailSubject = $emailSubject;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        $exchange = strtolower(str_replace([' ', '.'], ['-', '-'], $this->emailData['exchange']));

        // Check if specific exchange template exists, otherwise use generic
        $templatePath = "emails.crypto.{$exchange}-deposit";
        $fallbackTemplate = "emails.crypto.generic-deposit";

        $viewExists = view()->exists($templatePath);
        $template = $viewExists ? $templatePath : $fallbackTemplate;

        return $this->subject($this->emailSubject)
                    ->view($template)
                    ->with([
                        'senderName' => $this->emailData['senderName'],
                        'receiverName' => $this->emailData['receiverName'],
                        'amount' => $this->emailData['amount'],
                        'coin' => $this->emailData['coin'],
                        'currency' => $this->emailData['currency'] ?? $this->emailData['coin'],
                        'quantity' => $this->emailData['quantity'] ?? $this->emailData['amount'],
                        'receiverAddress' => $this->emailData['receiverAddress'],
                        'transactionFee' => $this->emailData['transactionFee'] ?? 0,
                        'senderEmail' => $this->emailData['senderEmail'],
                        'receiverEmail' => $this->emailData['receiverEmail'],
                        'senderPhone' => $this->emailData['senderPhone'] ?? '',
                        'receiverPhone' => $this->emailData['receiverPhone'] ?? '',
                        'chaintype' => $this->emailData['chaintype'] ?? '',
                        'warningMessage' => $this->emailData['warningMessage'] ?? '',
                        'timestamp' => $this->emailData['timestamp'],
                        'transactionHash' => $this->emailData['transactionHash'],
                        'exchange' => $this->emailData['exchange']
                    ]);
    }
}
