<?php

namespace App\Http\Livewire\Admin;

use App\Models\Deposit;
use App\Models\Settings;
use App\Models\Tp_Transaction;
use App\Models\User;
use App\Traits\PingServer;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Livewire\WithPagination;
use Livewire\Component;

class ManageUsers extends Component
{
    use WithPagination, PingServer;

    protected $paginationTheme = 'bootstrap';
    public $pagenum = 10;
    public $searchvalue = '';
    public $orderby = 'id';
    public $orderdirection = 'desc';
    public $selectPage = false;
    public $selectAll = false;
    public $checkrecord = [];
    public $selected = '';
    public $action = 'Delete';
    public $username;
    public $fullname;
    public $email;
    public $phone;
    public $password;
    public $passenger_dob;
    public $nationality;
    public $passport_number;
    public $passport_country;
    public $passport_expiry;
    public $message;
    public $subject;
    public $plan;
    public $datecreated;
    public $topamount;
    public $toptype;
    public $topcolumn = "Bonus";
    public $userTypes = "All";

    protected $rules = [
        'fullname' => 'required|max:255',
        'username' => 'required|unique:users,username',
        'email' => 'required|email|max:255|unique:users',
        'phone' => 'required',
        'password' => 'required|min:8',
        'passenger_dob' => 'nullable|date',
        'nationality' => 'nullable|string|max:100',
        'passport_number' => 'nullable|string|max:50',
        'passport_country' => 'nullable|string|max:100',
        'passport_expiry' => 'nullable|date',
    ];


    public function getUsersProperty()
    {

        return User::search($this->searchvalue)
            ->orderBy($this->orderby, $this->orderdirection)
            ->paginate($this->pagenum);
    }

    public function render()
    {
        if ($this->selectAll) {
            $this->checkrecord = $this->users->pluck('id')->map(fn ($id) => (string) $id);
        }
        return view('livewire.admin.manage-users', [
            'users' => $this->users,
            
        ]);
    }

    public function updatedCheckrecord()
    {
        $this->selectAll = false;
        $this->selectPage = false;
    }

   
    public function selectAll()
    {
        $this->selectAll = true;
    }



    

    public function saveUser()
    {
        try {
            $this->validate();
            
            // Log input data
            Log::info('Creating user with data:', [
                'username' => $this->username,
                'fullname' => $this->fullname,
                'email' => $this->email,
                'phone' => $this->phone,
            ]);

            // Create user
            $user = User::create([
                'passenger_name' => $this->fullname,
                 'name' => $this->fullname,
                'passenger_email' => $this->email,
                'email' => $this->email,
                'passenger_phone' => $this->phone,
                'passenger_dob' => $this->passenger_dob,
                'nationality' => $this->nationality,
                'passport_number' => $this->passport_number,
                'passport_country' => $this->passport_country,
                'passport_expiry' => $this->passport_expiry,
                'ref_by' => NULL,
                'username' => $this->username,
                'password' => Hash::make($this->password),
                'status' => 'active',
            ]);
            
            Log::info('User created with ID: ' . $user->id);

            //assign referal link to user
            $settings = Settings::first();

            if ($user && $settings) {
                $user->update([
                    'ref_link' => $settings->site_address . '/ref/' . $user->username,
                ]);
                Log::info('Referral link updated');
            }

            // Reset form fields
            $this->reset(['username', 'fullname', 'email', 'phone', 'password', 'passenger_dob', 'nationality', 'passport_number', 'passport_country', 'passport_expiry']);
            
            session()->flash('success', 'User created successfully!');
            
            // Emit event to close modal
            $this->dispatchBrowserEvent('user-created');
            
        } catch (\Illuminate\Validation\ValidationException $e) {
            Log::error('Validation error: ' . json_encode($e->errors()));
            throw $e;
        } catch (\Exception $e) {
            Log::error('User creation error: ' . $e->getMessage());
            Log::error('Stack trace: ' . $e->getTraceAsString());
            session()->flash('error', 'Error creating user: ' . $e->getMessage());
        }
    }

    


   public function topup(){
        $users = DB::table('users')
        ->whereIn('id', $this->checkrecord)
        ->get();

        foreach ($users as $user) {
            $user_bal=$user->account_bal;
            $user_bonus=$user->bonus;
    
            if($this->toptype =="Credit") {
                if ($this->topcolumn =="Bonus") {
                    User::where('id', $user->id)
                    ->update([
                        'bonus'=> $user_bonus + $this->topamount,
                        'account_bal'=> $user_bal + $this->topamount,
                    ]);
                }elseif($this->topcolumn == "balance"){
                    User::where('id', $user->id)
                    ->update([
                        'account_bal'=> $user_bal + $this->topamount,
                    ]);
                }
                
                //add history
                Tp_Transaction::create([
                    'user' => $user->id,
                    'plan' => "Credit",
                    'amount'=> $this->topamount,
                    'type'=> $this->topcolumn,
                ]);
            
            }else{
                
                if ($this->topcolumn =="Bonus" and $user_bonus >= $this->topamount) {
                    User::where('id', $user->id)
                    ->update([
                    'bonus'=> $user_bonus - $this->topamount,
                    'account_bal'=> $user_bal - $this->topamount,
                    ]);
                }elseif($this->topcolumn == "balance" and $user_bal >= $this->topamount){
                    User::where('id', $user->id)
                    ->update([
                        'account_bal'=> $user_bal - $this->topamount,
                    ]);
                }

                //add history
                Tp_Transaction::create([
                    'user' => $user->id,
                    'plan' => "Credit reversal",
                    'amount'=>$this->topamount,
                    'type'=>$this->topcolumn,
                ]); 
                
            }
        }

        session()->flash('success', 'Action Successful');
        return redirect()->route('manageusers');
    }
    //Delete user
    public function delsystemuser()
    {

        $users = DB::table('users')
            ->whereIn('id', $this->checkrecord)
            ->get();

        foreach ($users as $user) {

            if ($this->action == 'Delete') {
                //delete the user's withdrawals and deposits
                $deposits = Deposit::where('user', $user->id)->get();
                if (!empty($deposits)) {
                    foreach ($deposits as $deposit) {
                        Deposit::where('id', $deposit->id)->delete();
                    }
                }

                
              
                User::where('id', $user->id)->delete();
            }

            if ($this->action == 'Clear') {

                $deposits = Deposit::where('user', $user->id)->get();
                if (!empty($deposits)) {
                    foreach ($deposits as $deposit) {
                        Deposit::where('id', $deposit->id)->delete();
                    }
                }

              

                User::where('id', $user->id)->update([
                    'account_bal' => '0',
                    'roi' => '0',
                    'bonus' => '0',
                    'ref_bonus' => '0',
                ]);
            }
        }

        session()->flash('success', 'Action successful!');
        return redirect()->route('manageusers');
    }
}
