<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Settings;
use App\Models\Plans;

use App\Models\Admin;
use App\Models\Faq;
use App\Models\Images;
use App\Models\Testimony;
use App\Models\Content;
use App\Models\Asset;
use Illuminate\Support\Facades\Validator;
use App\Models\Mt4Details;
use App\Models\Deposit;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use App\Mail\NewNotification;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;

class HomePageController extends Controller
{
    public function index(){
        $settings=Settings::where('id', '=', '1')->first();
        //sum total deposited
        $total_deposits = DB::table('deposits')->select(DB::raw("SUM(amount) as total"))->
        where('status','Processed')->get();




        return view('home.index')->with(array(
            'settings' => $settings,
            'total_users' => User::count(),

            'title' => $settings->site_title,

        ));
    }

    //Licensing and registration route
    public function licensing(){

        return view('home.licensing')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
            'pplans' => Plans::where('type','Promo')->get(),
            'title' => 'Licensing, regulation and registration',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //Terms of service route
    public function terms(){

        return view('home.terms')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
            'title' => 'Terms of Service',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //Privacy policy route
    public function privacy(){
        $terms = TermsPrivacy::find(1);
        if ($terms->useterms == 'no') {
           return redirect()->back();
        }
        return view('home.privacy')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
            'title' => 'Privacy Policy',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //FAQ route
    public function faq(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.faq')
        ->with(array(
            'title' => 'FAQs',
            'faqs'=> Faq::orderby('id', 'desc')->get(),
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }


 //FAQ route
    public function pricing(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.pricing')
        ->with(array(
            'title' => 'Pricing',
            'settings' => Settings::where('id', '=', '1')->first(),
           'plans' => Plans::all(),
        ));
    }
    //about route
    public function about(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.about')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),


            'title' => 'About',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

   // safety route
    public function safety(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.safety')
        ->with(array(



            'title' => 'Safety',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }



     // safety  trading
    public function  trading  (){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.trading  ')
        ->with(array(



            'title' => ' trading  ',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }


    // safety route
    public function service(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.service')
        ->with(array(



            'title' => 'Service',
            'settings' => Settings::where('id', '=', '1')->first(),
             'plans' => Plans::all(),
        ));
    }



     //route risk
    public function risk(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.risk')
        ->with(array(



            'title' => 'Risk',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

      //licences route
    public function licences(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.licences')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),


            'title' => 'licences',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }

    //Contact route
    public function contact(){
         $settings=Settings::where('id', '=', '1')->first();
        return view('home.contact')
        ->with(array(
            'mplans' => Plans::where('type','Main')->get(),
                'pplans' => Plans::where('type','Promo')->get(),


            'title' => 'Contact',
            'settings' => Settings::where('id', '=', '1')->first(),
        ));
    }



    //send contact message to admin email
    public function sendcontact(Request $request){

        $settings=Settings::where('id','1')->first();
        $objDemo = new \stdClass();
        $objDemo->message = substr(wordwrap($request['message'],70),0,350);
        $objDemo->sender = "$settings->site_name";
        $objDemo->date = \Carbon\Carbon::Now();
        $objDemo->subject = "$request->subject,  my email $request->email";
        Mail::bcc($settings->contact_email)->send(new NewNotification($objDemo));
        return redirect()->back()
        ->with('success', ' Your message was sent successfully!');
    }
}
